// Generic IO functions
#include <xc.h>

#ifndef _IO_H    /* Guard against multiple inclusion */
#define _IO_H

//          RA4 LED
//          RB6 SW1
//          RB7 SW2
//          RC9 SW3
//          RA3 SW4
//          RB4 SW5
//          RB10 SW6
//          RB11 SW7
//          RA2 REG1EN (5V for audio)
//          RP2 as MCLK
//          SPI2 for I2S on CS4334 DAC
//          SPI1 for SD Card (CD on RB13, pin24)
//          RB5 IC3 (amplifier) enable

void LEDSet(unsigned char state);
void IOIdle(void);
void IOInit(void);
unsigned char getSW(unsigned char n);
void reg1Set(unsigned char state);
void reg1Ramp(uint32_t state);
void ampSet(unsigned char state);
uint32_t getAnalog();
void DeinitSPI();
extern void delay(uint32_t t);      //in util.h, delays by t ms
extern void delayUs(uint32_t t);

#endif // _IO_H
